/**
* \file: WaylandSeat.h
*
* \version: 0.3
*
* \release: $Name:$
*
* Implements wl_seat, a set of input devices; ignores keyboard.
*
* \component: Unified SPI
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_WAYLAND_SEAT_H
#define USPI_WAYLAND_SEAT_H

#include <wayland-client-protocol.h>
#include <string>
#include <uspi_macros.h>

namespace adit { namespace uspi {

class WaylandConnection;

/** @class  WaylandSeat
 *  @brief  Class holding a Wayland Seat, which is basically a group of input devices
 */
class WaylandSeat
{
public:
    WaylandSeat() : mSeatId(0), mWlSeat(nullptr), mWlTouch(nullptr), mWlPointer(nullptr),
    mParentWaylandConnection(nullptr) { }

    ~WaylandSeat()
    {
        uspi_safe_call(wl_touch_release, mWlTouch);
        uspi_safe_call(wl_pointer_release, mWlPointer);
        uspi_safe_call(wl_seat_destroy, mWlSeat);
        /* todo find a better solution to implement a weak reference for
         * mParentWaylandConnection, destruction of back reference is not a task for here anyway */
    }

    /* accessors */
    uint32_t seatId() const { return mSeatId; }
    wl_seat* wlSeat() const { return mWlSeat; }
    wl_touch* wlTouch() const { return mWlTouch; }
    wl_pointer* wlPointer() const { return mWlPointer; }
    WaylandConnection* waylandConnection() const { return mParentWaylandConnection; }
    /* mutators */
    void setSeatName(std::string inSeatName) { mSeatName = inSeatName; }
    void setSeatId(uint32_t inSeatId) { mSeatId = inSeatId; }
    void setWlSeat(wl_seat* inWlSeat) { mWlSeat = inWlSeat; }
    void setWlTouch(wl_touch* inWlTouch) { mWlTouch = inWlTouch; }
    void setWlPointer(wl_pointer* inWlPointer) { mWlPointer = inWlPointer; }
    void setWaylandConnection(WaylandConnection* inConnection) { mParentWaylandConnection = inConnection; }

private:
    std::string mSeatName;
    uint32_t mSeatId;
    wl_seat* mWlSeat;
    wl_touch* mWlTouch;
    wl_pointer* mWlPointer;

    WaylandConnection* mParentWaylandConnection;
};

} } /* namespace adit { namespace uspi { */

#endif /* USPI_WAYLAND_SEAT_H */
